#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

#define ll long long
#define vll vector<ll>

struct dp_element
{
	ll min_element, count;
};

vector<vector<dp_element>> upper_dp_array, lower_dp_array;

dp_element compute_lower_dp(vector<vll>* inputs, int i, int j)
{
	dp_element solution;
	int n = inputs->size();
	int m = inputs->at(0).size();
	if (i == n || j == m)
	{
		solution.count = 0; solution.min_element = LLONG_MAX;
		return solution;
	}
	if (lower_dp_array[i][j].min_element != -1)
	{
		return lower_dp_array[i][j];
	}
	if (i == n-1 && j == m-1)
	{
		solution.count = 1; solution.min_element = inputs->at(i)[j];
		lower_dp_array[i][j] = solution;
		return solution;
	}
	ll current_element = inputs->at(i)[j];

	dp_element bottom_min = compute_lower_dp(inputs, i + 1, j);
	dp_element right_min = compute_lower_dp(inputs, i, j + 1);
	dp_element cross = compute_lower_dp(inputs, i + 1, j + 1);

	dp_element total;

	if (bottom_min.min_element == right_min.min_element)
	{
		total.min_element = bottom_min.min_element;
		total.count = bottom_min.count + right_min.count;
		if (cross.min_element == total.min_element)
		{
			total.count -= cross.count;
		}
	}
	else
	{
		if (bottom_min.min_element < right_min.min_element)
			total = bottom_min;
		else
			total = right_min;
	}
	if (current_element == total.min_element)
	{
		total.count++;
	}
	if (current_element < total.min_element)
	{
		total.min_element = current_element;
		total.count = 1;
	}
	lower_dp_array[i][j] = total;
	return total;
}

dp_element compute_upper_dp(vector<vll>* inputs, int i, int j)
{
	dp_element solution;
	if (i == -1 || j == -1)
	{
		solution.count = 0; solution.min_element = LLONG_MAX;
		return solution;
	}
	if (upper_dp_array[i][j].min_element != -1)
	{
		return upper_dp_array[i][j];
	}
	if (i == 0 && j == 0)
	{
		solution.count = 1; solution.min_element = inputs->at(i)[j];
		upper_dp_array[0][0] = solution;
		return solution;
	}
	ll current_element = inputs->at(i)[j];

	dp_element upper_min = compute_upper_dp(inputs, i - 1, j);
	dp_element left_min = compute_upper_dp(inputs, i, j - 1);
	dp_element cross = compute_upper_dp(inputs, i - 1, j - 1);

	dp_element total;

	if (upper_min.min_element == left_min.min_element)
	{
		total.min_element = upper_min.min_element;
		total.count = upper_min.count + left_min.count;
		if (cross.min_element == total.min_element)
		{
			total.count -= cross.count;
		}
	}
	else
	{
		if (upper_min.min_element < left_min.min_element)
			total = upper_min;
		else
			total = left_min;
	}
	if (current_element == total.min_element)
	{
		total.count++;
	}
	if (current_element < total.min_element)
	{
		total.min_element = current_element;
		total.count = 1;
	}
	upper_dp_array[i][j] = total;
	return total;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	int n, m, q;
	cin >> n >> m >> q;
	vector<vll> inputs = vector<vll>(n);
	upper_dp_array = vector<vector<dp_element>>(n);
	lower_dp_array = vector<vector<dp_element>>(n);
	for (int row = 0; row < n; row++)
	{
		inputs[row] = vll(m);
		dp_element default_val = { -1,-1 };
		upper_dp_array[row] = vector<dp_element>(m, default_val);
		lower_dp_array[row] = vector<dp_element>(m, default_val);
		for (int col = 0; col < m; col++)
		{
			cin>>inputs[row][col];
		}
	}

	compute_upper_dp(&inputs, n - 1, m - 1);
	compute_lower_dp(&inputs, 0, 0);

	for (int q_index = 0; q_index < q; q_index++)
	{
		int ul_row, ul_col, w, h;
		cin >> ul_row >> ul_col >> w >> h;
		ul_row--; ul_col--;
		dp_element total; total.min_element = LLONG_MAX;
		dp_element upper_section = { LLONG_MAX, 0 }, left_section = { LLONG_MAX, 0 }, 
			right_section = { LLONG_MAX, 0 }, bottom_section = { LLONG_MAX, 0 };
		if (ul_row != 0)
		{
			upper_section = upper_dp_array[ul_row - 1][m - 1];
			total = upper_section;
		}
		if (ul_col != 0)
		{
			left_section = upper_dp_array[n - 1][ul_col - 1];
			if (left_section.min_element == total.min_element)
			{
				total.count += left_section.count;
			}
			else if (left_section.min_element < total.min_element)
			{
				total = left_section;
			}
		}

		if (ul_row != 0 && ul_col != 0)
		{
			dp_element cross = upper_dp_array[ul_row - 1][ul_col - 1];
			if (cross.min_element == total.min_element)
			{
				total.count -= cross.count;
			}
		}

		if (ul_row + h != n)
		{
			bottom_section = lower_dp_array[ul_row + h][ul_col];
			if (bottom_section.min_element == total.min_element)
			{
				total.count += bottom_section.count;
			}
			else if (bottom_section.min_element < total.min_element)
			{
				total = bottom_section;
			}
		}
		if (ul_col + w != m)
		{
			right_section = lower_dp_array[ul_row][ul_col + w];
			if (right_section.min_element == total.min_element)
			{
				total.count += right_section.count;
			}
			else if (right_section.min_element < total.min_element)
			{
				total = right_section;
			}
		}

		if (ul_col + w != m && ul_row + h != n)
		{
			dp_element cross = lower_dp_array[ul_row + h][ul_col + w];
			if (cross.min_element == total.min_element)
			{
				total.count -= cross.count;
			}
		}
		cout << total.count << "\n";
	}

	return 0;
}